<?php
/*
Template Name: banktransfer
*/

global $wpdb;
$error_message = ''; // متغير لتخزين رسائل الخطأ

// --- الخطوة 1: معالجة النموذج قبل أي إخراج HTML ---
if (isset($_POST['sendConfirm'])) {

    // التحقق من أن المستخدم الذي أرسل النموذج مسجل دخوله
    if (is_user_logged_in()) {

        // التحقق من وجود ملف مرفق
        if (empty($_FILES['receiptScreen']['name'])) {
            $error_message = "<div class='error'><h1>الرجاء إرفاق صورة إيصال التحويل.</h1></div>";
        } else {
            // --- استخدام مسار الرفع المخصص ---
            $target_dir_name = 'uploads/tansfers/';
            $target_dir_path = WP_CONTENT_DIR . '/' . $target_dir_name;

            // التأكد من أن المجلد موجود، وإن لم يكن، يتم إنشاؤه
            if (!file_exists($target_dir_path)) {
                wp_mkdir_p($target_dir_path);
            }

            $file_name = $_FILES['receiptScreen']['name'];
            $temp = explode(".", $file_name);
            $newfilename = rand(1000, 9999) . round(microtime(true)) . '.' . end($temp);
            $target_file_path = $target_dir_path . $newfilename;

            // المسار الذي سيتم حفظه في قاعدة البيانات
            $db_file_path = $target_dir_name . $newfilename;

            // محاولة نقل الملف
            if (move_uploaded_file($_FILES["receiptScreen"]["tmp_name"], $target_file_path)) {

                // --- الخطوة 2: إدخال البيانات إلى قاعدة البيانات ---
                $k = isset($_COOKIE["cart"]) ? stripslashes($_COOKIE["cart"]) : '[]';
                $courses = json_decode($k);
                $coupon = isset($_GET['coup']) ? sanitize_text_field($_GET['coup']) : '';
                $price = isset($_GET['price']) ? sanitize_text_field($_GET['price']) : '';
                $Today = date('Y-m-d');
                $current_user_id = get_current_user_id();

                if (!empty($courses)) {
                    foreach ($courses as $course) {
                        $data = get_field('courses_paid', $course->courseid);
                        $data1 = [];
                        if (is_array($data)) {
                            foreach ($data as $dataa) {
                                $dataa['iswatched'] = 'false';
                                $data1[] = (object)$dataa;
                            }
                        }

                        // استخدام اسم الجدول مباشرة كما طلبت
                        $table_name = 'courses_paid';

                        $wpdb->insert(
                            $table_name,
                            array(
                                'coursid' => $course->courseid,
                                'userid' => $current_user_id,
                                'price' => $price,
                                'coupon' => $coupon,
                                'created_at' => $Today,
                                'lectures' => json_encode($data1),
                                'bank_id' => sanitize_text_field($_POST['bankName']),
                                'payment_method' => 'bank',
                                'price_paid' => sanitize_text_field($_POST['coursePrice']),
                                'transfer_id' => sanitize_text_field($_POST['receiptNum']),
                                'transfer_Name' => sanitize_text_field($_POST['receiptName']),
                                'screen' => $db_file_path, // حفظ المسار المخصص
                                'status' => 0,
                            )
                        );
                    }
                }

                // --- الخطوة 3: مسح سلة المشتريات وإعادة التوجيه ---
                setcookie('cart', '', time() - 3600, '/');
                unset($_COOKIE['cart']);

                wp_redirect(home_url());
                exit;

            } else {
                // حدث خطأ أثناء رفع الملف
                $error_message = "<div class='error'><h1>حدث خطأ أثناء رفع الملف. يرجى المحاولة مرة أخرى.</h1></div>";
            }
        }
    }
}

// --- الخطوة 4: بدء عرض الصفحة ---
get_header();
$home = home_url();

if (!is_user_logged_in()) {
    wp_redirect($home);
    exit;
}

if (isset($_GET['id'])) {
    $current_user = wp_get_current_user();
    $userId = get_current_user_id();
    $userName = esc_html($current_user->nickname);
    $courseId = $_GET['id'];
    $courseName = get_the_title($_GET['id']);
}

$args = array(
    'post_type' => 'banks',
    'posts_per_page' => -1,
);
$loop = new WP_Query($args);
?>

<h1 class="pagetit text-center">
    <?php the_title(); ?>
</h1>

<section class="content">
    <div class="container">
        <div class="page-main">

            <?php
            if (!empty($error_message)) {
                echo $error_message;
            }
            ?>

            <?php if (has_post_thumbnail()) : ?>
                <div class="page-thumb">
                    <?php the_post_thumbnail('full', ['class' => 'img-fluid mx-auto d-block']); ?>
                </div>
            <?php endif; ?>

            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                <div class="page-content">
                    <?php the_content(); ?>
                </div>
            <?php endwhile; endif; ?>

            <?php if ($loop->have_posts()) : ?>
                <?php while ($loop->have_posts()) : $loop->the_post(); ?>
                    <div class='row'>
                        <div class='col-lg-6 mb-3'>
                            <div class="input-group s5ssd">
                                <input type="text" class="form-control disabled bank-copy" disabled value="<?php the_title(); ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary copy-btn" type="button"><?php _e('نسخ', 'm7md') ?></button>
                                    <span class="copy-status alert alert-success" style="display: none;"><?php _e('تم النسخ!', 'm7md') ?></span>
                                </div>
                            </div>
                        </div>
                        <div class='col-lg-6 mb-3'>
                            <div class="input-group s5ssd">
                                <input type="text" class="form-control disabled bank-copy" disabled value="<?php the_field('Bank_account') ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary copy-btn" type="button"><?php _e('نسخ', 'm7md') ?></button>
                                    <span class="copy-status alert alert-success" style="display: none;"><?php _e('تم النسخ!', 'm7md') ?></span>
                                </div>
                            </div>
                        </div>
                        <div class='col-lg-6 mb-3'>
                            <div class="input-group s5ssd">
                                <input type="text" class="form-control disabled bank-copy" disabled value="<?php the_field('iban') ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary copy-btn" type="button"><?php _e('نسخ', 'm7md') ?></button>
                                    <span class="copy-status alert alert-success" style="display: none;"> <?php _e('تم النسخ!', 'm7md') ?></span>
                                </div>
                            </div>
                        </div>
                        <div class='col-lg-6 mb-3'>
                            <div class="input-group s5ssd">
                                <input type="text" class="form-control disabled bank-copy" disabled value="<?php the_field('com-name') ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary copy-btn" type="button"><?php _e('نسخ', 'm7md') ?></button>
                                    <span class="copy-status alert alert-success" style="display: none;">  <?php _e('تم النسخ!', 'm7md') ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; $loop->rewind_posts(); // إعادة المؤشر لاستخدامه في القائمة المنسدلة ?>
            <?php endif; ?>

            <div class="form-subscribe">
                <form action="" method="post" enctype="multipart/form-data">
                    <input id="courseName" class="form-control" type="hidden" value="<?php echo isset($courseId) ? esc_attr($courseId) : ''; ?>" name="courseName" readonly>
                    <input id="userName" class="form-control" type="hidden" value="<?php echo isset($userId) ? esc_attr($userId) : ''; ?>" name="userName" readonly>

                    <div class="form-group form-focused">
                        <label for="receiptName"><?php _e('اسم صاحب الحساب', 'm7md') ?></label>
                        <input id="receiptName" class="form-control" type="text" name="receiptName" required>
                    </div>
                    <div class="form-group selesc">
                        <label><?php _e('البنك المحول اليه', 'm7md') ?></label>
                        <select class="custom-select" name="bankName" required>
                            <option value="" selected disabled><?php _e('برجاء اختيار البنك المحول إليه', 'm7md') ?></option>
                            <?php if ($loop->have_posts()) : while ($loop->have_posts()) : $loop->the_post(); ?>
                                <option value="<?php the_ID(); ?>"><?php the_title(); ?></option>
                            <?php endwhile; endif; ?>
                        </select>
                    </div>
                    <div class="form-group form-focused">
                        <label for="coursePrice"><?php _e('المبلغ المحول', 'm7md') ?></label>
                        <input id="coursePrice" class="form-control" type="number" step="0.01" name="coursePrice" required>
                    </div>
                    <div class="form-group form-focused">
                        <label for="receiptNum"><?php _e('رقم الايصال', 'm7md') ?></label>
                        <input id="receiptNum" class="form-control" type="text" name="receiptNum" required>
                    </div>
                    <div class="form-group uploadBox">
                        <label for="uploadFile" class="uploadFileLabel"><?php _e('ارفق الايصال', 'm7md') ?></label>
                        <input type="file" class="uploadFile" id="uploadFile" name="receiptScreen" accept="image/*" required>
                    </div>
                    <div class="text-center fdfds">
                        <input type="submit" class="main-button" name="sendConfirm" value="<?php _e('تأكيد', 'm7md') ?>">
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<script>
    document.querySelectorAll(".copy-btn").forEach((button) => {
        button.addEventListener("click", function() {
            const inputField = this.closest(".input-group").querySelector(".bank-copy");
            navigator.clipboard.writeText(inputField.value).then(() => {
                const status = this.closest(".input-group").querySelector(".copy-status");
                status.style.display = "inline";
                setTimeout(() => { status.style.display = "none"; }, 2000);
            }).catch(() => { alert("حدث خطأ أثناء النسخ."); });
        });
    });
</script>

<?php
wp_reset_postdata();
get_footer();
?>
